/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class TextAreaOutputStream
extends OutputStream {
    private final JFrame main = new JFrame("System.out");
    private final StringBuilder sb = new StringBuilder();
    private final JTextArea textArea;

    public TextAreaOutputStream() {
        this(25, 80);
    }

    public TextAreaOutputStream(int rows, int columns) {
        this.textArea = new JTextArea(rows, columns);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        System.setOut(new PrintStream(this));
        Container contentPane = this.main.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)new JScrollPane(this.textArea, 22, 31), "Center");
        this.main.setDefaultCloseOperation(2);
        this.main.pack();
        this.main.setVisible(true);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    @Override
    public void write(int b) throws IOException {
        if (b == 13) {
            return;
        }
        if (b == 10) {
            String text = this.sb.toString() + "\n";
            this.textArea.append(text);
            this.sb.setLength(0);
        } else {
            this.sb.append((char)b);
        }
    }
}

