/*
 * Decompiled with CFR 0.152.
 */
package input_data;

import java.io.InputStream;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Scanner;

public final class DataReader {
    private static double[] readDouble(Scanner input, int maxSize) {
        double[] ret = new double[maxSize];
        int actualSize = 0;
        try {
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = input.nextDouble();
                ++actualSize;
            }
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        if (actualSize != maxSize) {
            return Arrays.copyOf(ret, actualSize);
        }
        return ret;
    }

    private static int[] readInt(Scanner input, int maxSize) {
        int[] ret = new int[maxSize];
        int actualSize = 0;
        try {
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = input.nextInt();
                ++actualSize;
            }
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        if (actualSize != maxSize) {
            return Arrays.copyOf(ret, actualSize);
        }
        return ret;
    }

    public static int[] readShuffleData(int func_num, int nx) {
        int size = nx;
        if (size != -1) {
            String fn = "/input_data/shuffle_data_" + func_num + "_D" + nx + ".txt";
            InputStream dataFile = DataReader.class.getResourceAsStream(fn);
            return DataReader.readInt(new Scanner(dataFile), size);
        }
        return null;
    }

    public static double[] readRotation(int func_num, int nx, int cf_num) {
        int size = func_num < 13 ? nx * nx : cf_num * nx * nx;
        String fn = "/input_data/M_" + func_num + "_D" + nx + ".txt";
        InputStream dataFile = DataReader.class.getResourceAsStream(fn);
        return DataReader.readDouble(new Scanner(dataFile), size);
    }

    public static double[] readShiftData(int func_num, int nx, int cf_num) {
        int size = func_num < 13 ? nx : nx * cf_num;
        String fn = "/input_data/shift_data_" + func_num + "_D" + nx + ".txt";
        InputStream dataFile = DataReader.class.getResourceAsStream(fn);
        return DataReader.readDouble(new Scanner(dataFile), size);
    }
}

