/*
 * Decompiled with CFR 0.152.
 */
package cec2015.profiler;

import cec2015.math.Statistics;
import cec2015.profiler.OptimResults;
import cec2015.profiler.RecordRule;
import io.IOUtils;
import java.util.ArrayList;
import java.util.Arrays;

public class ResultRecorder {
    private final ArrayList<OptimResults> results = new ArrayList();
    private final RecordRule rule = new RecordRule();
    private String filePrefix;

    public ResultRecorder(String resultfilePrefix) {
        this.filePrefix = resultfilePrefix;
    }

    private String makeupFilename(int func_num, int dim, int runtime) {
        return this.filePrefix + "-f" + func_num + "-d" + dim + "-r" + runtime;
    }

    private String makeupResultHistory(int func_num, int dim) {
        return this.filePrefix + "-hist-f" + func_num + "-d" + dim + ".txt";
    }

    private String makeupStatFilename(int dim) {
        return this.filePrefix + "-stat-d" + dim + ".txt";
    }

    public void setFilenamePrefix(String prx) {
        this.filePrefix = prx;
        for (OptimResults result : this.results) {
            result.setFilename(this.makeupFilename(result.getFuncNum(), result.getDim(), result.getRuntime()));
        }
    }

    protected OptimResults getResults(int func_num, int nx, int runtime) {
        for (OptimResults result : this.results) {
            if (result.getFuncNum() != func_num || result.getDim() != nx || result.getRuntime() != runtime) continue;
            return result;
        }
        OptimResults or = new OptimResults(this.makeupFilename(func_num, nx, runtime), func_num, nx, runtime);
        this.results.add(or);
        return or;
    }

    public void addRecordRule(int dim, int[] rp) {
        this.rule.addRule(dim, rp);
    }

    public void flush() {
        int[] dims;
        for (OptimResults result : this.results) {
            result.flush();
        }
        int[] funs = this.getFunNumArray();
        for (int d : dims = this.getDimArray()) {
            String stat = this.getStatistics(d);
            if (stat != null) {
                IOUtils.flush(this.makeupStatFilename(d), stat);
            }
            for (int f : funs) {
                String hist = this.getHistory(f, d);
                if (hist == null) continue;
                IOUtils.flush(this.makeupResultHistory(f, d), hist);
            }
        }
    }

    void record(int func_num, int nx, int runtime, int count, double[] x, double fx) {
        OptimResults or = this.getResults(func_num, nx, runtime);
        if (this.rule.isRecord(nx, count)) {
            or.record(count, x, fx);
        }
    }

    private int[] getFunNumArray() {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (OptimResults result : this.results) {
            if (ret.contains(result.getFuncNum())) continue;
            ret.add(result.getFuncNum());
        }
        int[] funs = new int[ret.size()];
        for (int i = 0; i < ret.size(); ++i) {
            funs[i] = (Integer)ret.get(i);
        }
        Arrays.sort(funs);
        return funs;
    }

    private int[] getDimArray() {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (OptimResults result : this.results) {
            if (ret.contains(result.getDim())) continue;
            ret.add(result.getDim());
        }
        int[] funs = new int[ret.size()];
        for (int i = 0; i < ret.size(); ++i) {
            funs[i] = (Integer)ret.get(i);
        }
        Arrays.sort(funs);
        return funs;
    }

    private int[] getRuntimeArray() {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (OptimResults result : this.results) {
            if (ret.contains(result.getRuntime())) continue;
            ret.add(result.getRuntime());
        }
        int[] funs = new int[ret.size()];
        for (int i = 0; i < ret.size(); ++i) {
            funs[i] = (Integer)ret.get(i);
        }
        Arrays.sort(funs);
        return funs;
    }

    private int getIndex(int value, int[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != value) continue;
            return i;
        }
        return -1;
    }

    private boolean isRecorded(int f, int d) {
        for (OptimResults result : this.results) {
            if (result.getFuncNum() != f || result.getDim() != d || result.getRecordedY() == null) continue;
            return true;
        }
        return false;
    }

    private double[][] getResultTable(int funNum, int dim) {
        if (!this.isRecorded(funNum, dim)) {
            return null;
        }
        int[] runtimes = this.getRuntimeArray();
        double[][] ret = new double[runtimes.length][];
        for (OptimResults result : this.results) {
            int index;
            if (result.getFuncNum() != funNum || result.getDim() != dim || (index = this.getIndex(result.getRuntime(), runtimes)) == -1) continue;
            ret[index] = result.getRecordedY();
        }
        return ret;
    }

    private String getHistory(int fun, int d) {
        double[][] ret = this.getResultTable(fun, d);
        if (ret == null) {
            return null;
        }
        int[] runtimes = this.getRuntimeArray();
        String retStr = "% Run\n";
        for (int i = 0; i < runtimes.length; ++i) {
            retStr = retStr + runtimes[i] + "\t";
            if (ret[i] == null) continue;
            for (int j = 0; j < ret[i].length - 1; ++j) {
                retStr = retStr + ret[i][j] + "\t";
            }
            retStr = retStr + ret[i][ret[i].length - 1] + "\n";
        }
        return retStr;
    }

    private String getStatistics(int dim) {
        int[] funs = this.getFunNumArray();
        String retStr = "%%\t\tStatistics result of " + dim + "D\n% Func.\tBest\tWorst\tMedian\tMean\tStd\n";
        for (int f : funs) {
            double[] stat = this.getStatistics(f, dim);
            if (stat == null) continue;
            retStr = retStr + f + "\t";
            for (int i = 0; i < stat.length - 1; ++i) {
                retStr = retStr + stat[i] + "\t";
            }
            retStr = retStr + stat[stat.length - 1] + "\n";
        }
        return retStr;
    }

    private double[] getStatistics(int funNum, int dim) {
        if (!this.isRecorded(funNum, dim)) {
            return null;
        }
        double[][] table = this.getResultTable(funNum, dim);
        double[] stat = new double[5];
        int runtimes = table.length;
        int n = table.length;
        for (double[] tt : table) {
            if (tt != null) continue;
            --n;
        }
        double[] result = new double[n];
        for (int i = 0; i < result.length; ++i) {
            if (table[i] == null) continue;
            result[i] = table[i][table[i].length - 1];
        }
        Arrays.sort(result, 0, result.length);
        stat[0] = Statistics.calculateMin(result);
        stat[1] = Statistics.calculateMax(result);
        stat[2] = Statistics.calculateMedian(result);
        stat[3] = Statistics.calculateMean(result);
        stat[4] = Statistics.calculateStandardDeviation(result);
        return stat;
    }
}

