/*
 * Decompiled with CFR 0.152.
 */
package cec2015.profiler;

import io.IOUtils;
import java.util.ArrayList;

public class OptimResults {
    private final ArrayList<double[]> xdata = new ArrayList();
    private final ArrayList<Double> ydata = new ArrayList();
    private final ArrayList<Integer> recordnumber = new ArrayList();
    private String filename;
    private final int func_num;
    private final int dim;
    private final int runtime;

    OptimResults(String resultfilename, int func_num, int dim, int runtime) {
        this.filename = resultfilename;
        this.func_num = func_num;
        this.dim = dim;
        this.runtime = runtime;
    }

    void setFilename(String fn) {
        this.filename = fn;
    }

    public int getFuncNum() {
        return this.func_num;
    }

    public int getDim() {
        return this.dim;
    }

    public int getRuntime() {
        return this.runtime;
    }

    int[] getRecordPoints() {
        if (this.recordnumber.isEmpty()) {
            return null;
        }
        int[] ret = new int[this.recordnumber.size()];
        for (int i = 0; i < this.recordnumber.size(); ++i) {
            ret[i] = this.recordnumber.get(i);
        }
        return ret;
    }

    double[] getRecordedY() {
        if (this.ydata.isEmpty()) {
            return null;
        }
        double[] ret = new double[this.ydata.size()];
        for (int i = 0; i < this.ydata.size(); ++i) {
            ret[i] = this.ydata.get(i);
        }
        return ret;
    }

    void record(int count, double[] x, double fx) {
        this.xdata.add(x);
        this.ydata.add(fx);
        this.recordnumber.add(count);
    }

    void flush() {
        IOUtils.flush(this.filename + "-x.txt", this.reportX());
        IOUtils.flush(this.filename + "-fx.txt", this.reportY());
    }

    private String reportX() {
        String rep = "%count   \tx\n";
        for (int i = 0; i < this.recordnumber.size(); ++i) {
            int rn = this.recordnumber.get(i);
            double[] x = this.xdata.get(i);
            rep = rep + "  " + rn + "\t";
            for (int j = 0; j < x.length; ++j) {
                rep = rep + x[j] + "\t";
            }
            rep = rep + "\n";
        }
        return rep;
    }

    private String reportY() {
        String rep = "%count   \ty\n";
        for (int i = 0; i < this.recordnumber.size(); ++i) {
            int rn = this.recordnumber.get(i);
            double fx = this.ydata.get(i);
            rep = rep + "  " + rn + "\t" + fx + "\n";
        }
        return rep;
    }
}

