/*
 * Decompiled with CFR 0.152.
 */
package cec2015.profiler;

import cec2015.profiler.ResultRecorder;

public class FEvCount {
    private int[][] counts = null;
    private double[][] currentBest = null;
    private final double[][][] currentBestX;
    private final int maxDimension;
    private final int problemCount;
    private ResultRecorder recorder;
    private final int currentRun;

    public FEvCount(int problemCount, int maxDimension, int run) {
        this(problemCount, maxDimension, run, null);
    }

    public FEvCount(int problemCount, int maxDimension, int run, ResultRecorder rr) {
        this.recorder = rr;
        this.problemCount = problemCount;
        this.maxDimension = maxDimension;
        this.currentRun = run;
        this.counts = new int[problemCount + 1][maxDimension + 1];
        this.currentBest = new double[problemCount + 1][maxDimension + 1];
        this.currentBestX = new double[problemCount + 1][maxDimension + 1][];
        for (int i = 1; i < this.counts.length; ++i) {
            for (int j = 1; j < this.counts[i].length; ++j) {
                this.counts[i][j] = 0;
                this.currentBest[i][j] = 1.0E99;
                this.currentBestX[i][j] = null;
            }
        }
    }

    public int getCurrentRun() {
        return this.currentRun;
    }

    public void setRocorer(ResultRecorder rr) {
        this.recorder = rr;
    }

    public int getCount(int func_num, int nx) {
        assert (func_num >= 1 || func_num <= this.problemCount);
        assert (nx <= this.maxDimension || nx >= 1);
        return this.counts[func_num][nx];
    }

    public double[] getCurrentBestX(int func_num, int nx) {
        assert (func_num >= 1 || func_num <= this.problemCount);
        assert (nx <= this.maxDimension || nx >= 1);
        return this.currentBestX[func_num][nx];
    }

    public double getCurrentBest(int func_num, int nx) {
        assert (func_num >= 1 || func_num <= this.problemCount);
        assert (nx <= this.maxDimension || nx >= 1);
        return this.currentBest[func_num][nx];
    }

    public void eval(int func_num, int nx, double[] x, double[] fx) {
        int evalcount = x.length / nx;
        assert (evalcount == fx.length);
        assert (func_num < 1 || func_num > this.problemCount);
        for (int i = 0; i < fx.length; ++i) {
            double[] tx;
            if (fx[i] < this.currentBest[func_num][nx]) {
                this.currentBest[func_num][nx] = fx[i];
                tx = new double[nx];
                System.arraycopy(x, i * nx, tx, 0, nx);
                this.currentBestX[func_num][nx] = tx;
            }
            if (this.recorder == null) continue;
            tx = new double[nx];
            System.arraycopy(x, i * nx, tx, 0, nx);
            this.recorder.record(func_num, nx, this.currentRun, this.getCount(func_num, nx) + i + 1, this.currentBestX[func_num][nx], this.currentBest[func_num][nx]);
        }
        int[] nArray = this.counts[func_num];
        int n = nx;
        nArray[n] = nArray[n] + evalcount;
    }
}

