/*
 * Decompiled with CFR 0.152.
 */
package cec2015.math;

import java.util.Arrays;

public class Statistics {
    public static double calculateMean(double[] array) {
        double sum = 0.0;
        for (int i = 0; i < array.length; ++i) {
            sum += array[i];
        }
        double mean = sum / (double)array.length;
        return mean;
    }

    public static double calculateMax(double[] array) {
        double maxSeenSoFar = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (!(array[i] > maxSeenSoFar)) continue;
            maxSeenSoFar = array[i];
        }
        return maxSeenSoFar;
    }

    public static double calculateMin(double[] array) {
        double minSeenSoFar = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (!(array[i] < minSeenSoFar)) continue;
            minSeenSoFar = array[i];
        }
        return minSeenSoFar;
    }

    public static void selectionSort(double[] array) {
        for (int tail = array.length - 1; tail > 0; --tail) {
            double maxSeen = array[0];
            int posMaxSeen = 0;
            for (int i = 1; i <= tail; ++i) {
                if (!(maxSeen < array[i])) continue;
                maxSeen = array[i];
                posMaxSeen = i;
            }
            array[posMaxSeen] = array[tail];
            array[tail] = maxSeen;
        }
    }

    private static double[] copyArray(double[] array) {
        double[] copy = Arrays.copyOf(array, array.length);
        return copy;
    }

    public static double calculateMedian(double[] array) {
        double[] copy = Statistics.copyArray(array);
        Statistics.selectionSort(copy);
        double median = array.length % 2 == 1 ? copy[copy.length / 2] : (copy[copy.length / 2 - 1] + copy[copy.length / 2]) / 2.0;
        return median;
    }

    public static double calculateMode(double[] array) {
        double valueWithMaxCountSeen = array[0];
        double maxCountSeen = 1.0;
        for (int i = 0; i < array.length; ++i) {
            int count = 0;
            for (int j = 0; j < array.length; ++j) {
                if (array[j] != array[i]) continue;
                ++count;
            }
            if (!((double)count > maxCountSeen)) continue;
            maxCountSeen = count;
            valueWithMaxCountSeen = array[i];
        }
        return valueWithMaxCountSeen;
    }

    public static double calculateStandardDeviation(double[] array) {
        double mean = Statistics.calculateMean(array);
        double sum = 0.0;
        for (int i = 0; i < array.length; ++i) {
            sum += (array[i] - mean) * (array[i] - mean);
        }
        double variance = 0.0;
        if (array.length > 1) {
            variance = sum / (double)(array.length - 1);
        }
        double standardDeviation = Math.sqrt(variance);
        return standardDeviation;
    }
}

