/*
 * Decompiled with CFR 0.152.
 */
package cec2015.math;

import cec2015.math.ShiftRotation;
import java.util.Arrays;

public final class Functions {
    public static final double ellips_func(double[] x, int nx, double[] Os, double[] Mr, int s_flag, int r_flag) {
        double f = 0.0;
        double[] z = ShiftRotation.sr_func(x, nx, Os, Mr, 1.0, s_flag, r_flag);
        for (int i = 0; i < nx; ++i) {
            f += Math.pow(10.0, 6.0 * (double)i / (double)(nx - 1)) * z[i] * z[i];
        }
        return f;
    }

    public static final double bent_cigar_func(double[] x, int nx, double[] Os, double[] Mr, int s_flag, int r_flag) {
        double[] z = ShiftRotation.sr_func(x, nx, Os, Mr, 1.0, s_flag, r_flag);
        double f = z[0] * z[0];
        for (int i = 1; i < nx; ++i) {
            f += Math.pow(10.0, 6.0) * z[i] * z[i];
        }
        return f;
    }

    public static final double discus_func(double[] x, int nx, double[] Os, double[] Mr, int s_flag, int r_flag) {
        double[] z = ShiftRotation.sr_func(x, nx, Os, Mr, 1.0, s_flag, r_flag);
        double f = Math.pow(10.0, 6.0) * z[0] * z[0];
        for (int i = 1; i < nx; ++i) {
            f += z[i] * z[i];
        }
        return f;
    }

    public static final double rosenbrock_func(double[] x, int nx, double[] Os, double[] Mr, int s_flag, int r_flag) {
        double f = 0.0;
        double[] z = ShiftRotation.sr_func(x, nx, Os, Mr, 0.02048, s_flag, r_flag);
        z[0] = z[0] + 1.0;
        for (int i = 0; i < nx - 1; ++i) {
            int n = i + 1;
            z[n] = z[n] + 1.0;
            double tmp1 = z[i] * z[i] - z[i + 1];
            double tmp2 = z[i] - 1.0;
            f += 100.0 * tmp1 * tmp1 + tmp2 * tmp2;
        }
        return f;
    }

    public static final double ackley_func(double[] x, int nx, double[] Os, double[] Mr, int s_flag, int r_flag) {
        double sum1 = 0.0;
        double sum2 = 0.0;
        double[] z = ShiftRotation.sr_func(x, nx, Os, Mr, 1.0, s_flag, r_flag);
        for (int i = 0; i < nx; ++i) {
            sum1 += z[i] * z[i];
            sum2 += Math.cos(Math.PI * 2 * z[i]);
        }
        sum1 = -0.2 * Math.sqrt(sum1 / (double)nx);
        return Math.E - 20.0 * Math.exp(sum1) - Math.exp(sum2 /= (double)nx) + 20.0;
    }

    public static final double weierstrass_func(double[] x, int nx, double[] Os, double[] Mr, int s_flag, int r_flag) {
        double sum2 = 0.0;
        double[] z = ShiftRotation.sr_func(x, nx, Os, Mr, 0.005, s_flag, r_flag);
        double a = 0.5;
        double b = 3.0;
        int k_max = 20;
        double f = 0.0;
        for (int i = 0; i < nx; ++i) {
            double sum = 0.0;
            sum2 = 0.0;
            for (int j = 0; j <= k_max; ++j) {
                sum += Math.pow(a, j) * Math.cos(Math.PI * 2 * Math.pow(b, j) * (z[i] + 0.5));
                sum2 += Math.pow(a, j) * Math.cos(Math.PI * 2 * Math.pow(b, j) * 0.5);
            }
            f += sum;
        }
        return f -= (double)nx * sum2;
    }

    public static final double griewank_func(double[] x, int nx, double[] Os, double[] Mr, int s_flag, int r_flag) {
        double[] z = ShiftRotation.sr_func(x, nx, Os, Mr, 6.0, s_flag, r_flag);
        double s = 0.0;
        double p = 1.0;
        for (int i = 0; i < nx; ++i) {
            s += z[i] * z[i];
            p *= Math.cos(z[i] / Math.sqrt(1.0 + (double)i));
        }
        return 1.0 + s / 4000.0 - p;
    }

    public static final double rastrigin_func(double[] x, int nx, double[] Os, double[] Mr, int s_flag, int r_flag) {
        double f = 0.0;
        double[] z = ShiftRotation.sr_func(x, nx, Os, Mr, 0.0512, s_flag, r_flag);
        for (int i = 0; i < nx; ++i) {
            f += z[i] * z[i] - 10.0 * Math.cos(Math.PI * 2 * z[i]) + 10.0;
        }
        return f;
    }

    public static final double schwefel_func(double[] x, int nx, double[] Os, double[] Mr, int s_flag, int r_flag) {
        double[] z = ShiftRotation.sr_func(x, nx, Os, Mr, 10.0, s_flag, r_flag);
        double f = 0.0;
        for (int i = 0; i < nx; ++i) {
            double tmp;
            int n = i;
            z[n] = z[n] + 420.9687462275036;
            if (z[i] > 500.0) {
                f -= (500.0 - z[i] % 500.0) * Math.sin(Math.pow(500.0 - z[i] % 500.0, 0.5));
                tmp = (z[i] - 500.0) / 100.0;
                f += tmp * tmp / (double)nx;
                continue;
            }
            if (z[i] < -500.0) {
                f -= (-500.0 + Math.abs(z[i]) % 500.0) * Math.sin(Math.pow(500.0 - Math.abs(z[i]) % 500.0, 0.5));
                tmp = (z[i] + 500.0) / 100.0;
                f += tmp * tmp / (double)nx;
                continue;
            }
            f -= z[i] * Math.sin(Math.pow(Math.abs(z[i]), 0.5));
        }
        f = 418.9828872724338 * (double)nx + f;
        return f;
    }

    public static final double katsuura_func(double[] x, int nx, double[] Os, double[] Mr, int s_flag, int r_flag) {
        double tmp1;
        double tmp3 = Math.pow(1.0 * (double)nx, 1.2);
        double[] z = ShiftRotation.sr_func(x, nx, Os, Mr, 0.05, s_flag, r_flag);
        double f = 1.0;
        for (int i = 0; i < nx; ++i) {
            double temp = 0.0;
            for (int j = 1; j <= 32; ++j) {
                tmp1 = Math.pow(2.0, j);
                double tmp2 = tmp1 * z[i];
                temp += Math.abs(tmp2 - Math.floor(tmp2 + 0.5)) / tmp1;
            }
            f *= Math.pow(1.0 + (double)(i + 1) * temp, 10.0 / tmp3);
        }
        tmp1 = 10.0 / (double)nx / (double)nx;
        f = f * tmp1 - tmp1;
        return f;
    }

    public static final double happycat_func(double[] x, int nx, double[] Os, double[] Mr, int s_flag, int r_flag) {
        double alpha = 0.125;
        double[] z = ShiftRotation.sr_func(x, nx, Os, Mr, 0.05, s_flag, r_flag);
        double r2 = 0.0;
        double sum_z = 0.0;
        for (int i = 0; i < nx; ++i) {
            z[i] = z[i] - 1.0;
            r2 += z[i] * z[i];
            sum_z += z[i];
        }
        return Math.pow(Math.abs(r2 - (double)nx), 2.0 * alpha) + (0.5 * r2 + sum_z) / (double)nx + 0.5;
    }

    public static final double hgbat_func(double[] x, int nx, double[] Os, double[] Mr, int s_flag, int r_flag) {
        double alpha = 0.25;
        double[] z = ShiftRotation.sr_func(x, nx, Os, Mr, 0.05, s_flag, r_flag);
        double r2 = 0.0;
        double sum_z = 0.0;
        for (int i = 0; i < nx; ++i) {
            z[i] = z[i] - 1.0;
            r2 += z[i] * z[i];
            sum_z += z[i];
        }
        return Math.pow(Math.abs(Math.pow(r2, 2.0) - Math.pow(sum_z, 2.0)), 2.0 * alpha) + (0.5 * r2 + sum_z) / (double)nx + 0.5;
    }

    public static final double grie_rosen_func(double[] x, int nx, double[] Os, double[] Mr, int s_flag, int r_flag) {
        double temp;
        double tmp2;
        double tmp1;
        double[] z = ShiftRotation.sr_func(x, nx, Os, Mr, 0.05, s_flag, r_flag);
        double f = 0.0;
        z[0] = z[0] + 1.0;
        for (int i = 0; i < nx - 1; ++i) {
            int n = i + 1;
            z[n] = z[n] + 1.0;
            tmp1 = z[i] * z[i] - z[i + 1];
            tmp2 = z[i] - 1.0;
            temp = 100.0 * tmp1 * tmp1 + tmp2 * tmp2;
            f += temp * temp / 4000.0 - Math.cos(temp) + 1.0;
        }
        tmp1 = z[nx - 1] * z[nx - 1] - z[0];
        tmp2 = z[nx - 1] - 1.0;
        temp = 100.0 * tmp1 * tmp1 + tmp2 * tmp2;
        return f += temp * temp / 4000.0 - Math.cos(temp) + 1.0;
    }

    public static final double escaffer6_func(double[] x, int nx, double[] Os, double[] Mr, int s_flag, int r_flag) {
        double temp2;
        double temp1;
        double[] z = ShiftRotation.sr_func(x, nx, Os, Mr, 1.0, s_flag, r_flag);
        double f = 0.0;
        for (int i = 0; i < nx - 1; ++i) {
            temp1 = Math.sin(Math.sqrt(z[i] * z[i] + z[i + 1] * z[i + 1]));
            temp1 *= temp1;
            temp2 = 1.0 + 0.001 * (z[i] * z[i] + z[i + 1] * z[i + 1]);
            f += 0.5 + (temp1 - 0.5) / (temp2 * temp2);
        }
        temp1 = Math.sin(Math.sqrt(z[nx - 1] * z[nx - 1] + z[0] * z[0]));
        temp1 *= temp1;
        temp2 = 1.0 + 0.001 * (z[nx - 1] * z[nx - 1] + z[0] * z[0]);
        return f += 0.5 + (temp1 - 0.5) / (temp2 * temp2);
    }

    public static final double hf01(double[] x, int nx, double[] Os, double[] Mr, int[] S, int s_flag, int r_flag) {
        int ii;
        int i;
        int cf_num = 3;
        double[] fit = new double[3];
        int[] G = new int[3];
        int[] G_nx = new int[3];
        double[] Gp = new double[]{0.3, 0.3, 0.4};
        int tmp = 0;
        for (i = 0; i < cf_num - 1; ++i) {
            G_nx[i] = (int)Math.ceil(Gp[i] * (double)nx);
            tmp += G_nx[i];
        }
        G_nx[cf_num - 1] = nx - tmp;
        G[0] = 0;
        for (i = 1; i < cf_num; ++i) {
            G[i] = G[i - 1] + G_nx[i - 1];
        }
        double[] z = ShiftRotation.sr_func(x, nx, Os, Mr, 1.0, s_flag, r_flag);
        double[] y = new double[nx];
        for (i = 0; i < nx; ++i) {
            y[i] = z[S[i] - 1];
        }
        i = 0;
        double[] ty = new double[G_nx[i]];
        double[] tO = new double[G_nx[i]];
        double[] tM = new double[G_nx[i]];
        for (ii = 0; ii < G_nx[i]; ++ii) {
            ty[ii] = y[ii];
            tO[ii] = Os[ii];
            tM[ii] = Mr[i * nx + ii];
        }
        fit[i] = Functions.schwefel_func(ty, G_nx[i], tO, tM, 0, 0);
        i = 1;
        ty = new double[G_nx[i]];
        tO = new double[G_nx[i]];
        tM = new double[G_nx[i]];
        for (ii = 0; ii < G_nx[i]; ++ii) {
            ty[ii] = y[G_nx[i - 1] + ii];
            tO[ii] = Os[G_nx[i - 1] + ii];
            tM[ii] = Mr[i * nx + ii];
        }
        fit[i] = Functions.rastrigin_func(ty, G_nx[i], tO, tM, 0, 0);
        i = 2;
        ty = new double[G_nx[i]];
        tO = new double[G_nx[i]];
        tM = new double[G_nx[i]];
        for (ii = 0; ii < G_nx[i]; ++ii) {
            ty[ii] = y[G_nx[i - 2] + G_nx[i - 1] + ii];
            tO[ii] = Os[G_nx[i - 2] + G_nx[i - 1] + ii];
            tM[ii] = Mr[i * nx + ii];
        }
        fit[i] = Functions.ellips_func(ty, G_nx[i], tO, tM, 0, 0);
        double f = 0.0;
        for (i = 0; i < cf_num; ++i) {
            f += fit[i];
        }
        return f;
    }

    public static final double hf02(double[] x, int nx, double[] Os, double[] Mr, int[] S, int s_flag, int r_flag) {
        int ii;
        int i;
        int cf_num = 3;
        double[] fit = new double[3];
        int[] G = new int[3];
        int[] G_nx = new int[3];
        double[] Gp = new double[]{0.3, 0.3, 0.4};
        int tmp = 0;
        for (i = 0; i < cf_num - 1; ++i) {
            G_nx[i] = (int)Math.ceil(Gp[i] * (double)nx);
            tmp += G_nx[i];
        }
        G_nx[cf_num - 1] = nx - tmp;
        G[0] = 0;
        for (i = 1; i < cf_num; ++i) {
            G[i] = G[i - 1] + G_nx[i - 1];
        }
        double[] z = ShiftRotation.sr_func(x, nx, Os, Mr, 1.0, s_flag, r_flag);
        double[] y = new double[nx];
        for (i = 0; i < nx; ++i) {
            y[i] = z[S[i] - 1];
        }
        i = 0;
        double[] ty = new double[G_nx[i]];
        double[] tO = new double[G_nx[i]];
        double[] tM = new double[G_nx[i]];
        for (ii = 0; ii < G_nx[i]; ++ii) {
            ty[ii] = y[ii];
            tO[ii] = Os[ii];
            tM[ii] = Mr[i * nx + ii];
        }
        fit[i] = Functions.bent_cigar_func(ty, G_nx[i], tO, tM, 0, 0);
        i = 1;
        ty = new double[G_nx[i]];
        tO = new double[G_nx[i]];
        tM = new double[G_nx[i]];
        for (ii = 0; ii < G_nx[i]; ++ii) {
            ty[ii] = y[G_nx[i - 1] + ii];
            tO[ii] = Os[G_nx[i - 1] + ii];
            tM[ii] = Mr[i * nx + ii];
        }
        fit[i] = Functions.hgbat_func(ty, G_nx[i], tO, tM, 0, 0);
        i = 2;
        ty = new double[G_nx[i]];
        tO = new double[G_nx[i]];
        tM = new double[G_nx[i]];
        for (ii = 0; ii < G_nx[i]; ++ii) {
            ty[ii] = y[G_nx[i - 2] + G_nx[i - 1] + ii];
            tO[ii] = Os[G_nx[i - 1] + G_nx[i - 2] + ii];
            tM[ii] = Mr[i * nx + ii];
        }
        fit[i] = Functions.rastrigin_func(ty, G_nx[i], tO, tM, 0, 0);
        double f = 0.0;
        for (i = 0; i < cf_num; ++i) {
            f += fit[i];
        }
        return f;
    }

    public static final double hf03(double[] x, int nx, double[] Os, double[] Mr, int[] S, int s_flag, int r_flag) {
        int ii;
        int i;
        int cf_num = 4;
        double[] fit = new double[4];
        int[] G_nx = new int[4];
        int[] G = new int[4];
        double[] Gp = new double[]{0.2, 0.2, 0.3, 0.3};
        int tmp = 0;
        for (i = 0; i < cf_num - 1; ++i) {
            G_nx[i] = (int)Math.ceil(Gp[i] * (double)nx);
            tmp += G_nx[i];
        }
        G_nx[cf_num - 1] = nx - tmp;
        G[0] = 0;
        for (i = 1; i < cf_num; ++i) {
            G[i] = G[i - 1] + G_nx[i - 1];
        }
        double[] z = ShiftRotation.sr_func(x, nx, Os, Mr, 1.0, s_flag, r_flag);
        double[] y = new double[nx];
        for (i = 0; i < nx; ++i) {
            y[i] = z[S[i] - 1];
        }
        i = 0;
        double[] ty = new double[G_nx[i]];
        double[] tO = new double[G_nx[i]];
        double[] tM = new double[G_nx[i]];
        for (ii = 0; ii < G_nx[i]; ++ii) {
            ty[ii] = y[ii];
            tO[ii] = Os[ii];
            tM[ii] = Mr[i * nx + ii];
        }
        fit[i] = Functions.griewank_func(ty, G_nx[i], tO, tM, 0, 0);
        i = 1;
        ty = new double[G_nx[i]];
        tO = new double[G_nx[i]];
        tM = new double[G_nx[i]];
        for (ii = 0; ii < G_nx[i]; ++ii) {
            ty[ii] = y[G_nx[i - 1] + ii];
            tO[ii] = Os[G_nx[i - 1] + ii];
            tM[ii] = Mr[i * nx + ii];
        }
        fit[i] = Functions.weierstrass_func(ty, G_nx[i], tO, tM, 0, 0);
        i = 2;
        ty = new double[G_nx[i]];
        tO = new double[G_nx[i]];
        tM = new double[G_nx[i]];
        for (ii = 0; ii < G_nx[i]; ++ii) {
            ty[ii] = y[G_nx[i - 1] + G_nx[i - 2] + ii];
            tO[ii] = Os[G_nx[i - 1] + G_nx[i - 2] + ii];
            tM[ii] = Mr[i * nx + ii];
        }
        fit[i] = Functions.rosenbrock_func(ty, G_nx[i], tO, tM, 0, 0);
        i = 3;
        ty = new double[G_nx[i]];
        tO = new double[G_nx[i]];
        tM = new double[G_nx[i]];
        for (ii = 0; ii < G_nx[i]; ++ii) {
            ty[ii] = y[G_nx[i - 1] + G_nx[i - 2] + G_nx[i - 3] + ii];
            tO[ii] = Os[G_nx[i - 1] + G_nx[i - 2] + G_nx[i - 3] + ii];
            tM[ii] = Mr[i * nx + ii];
        }
        fit[i] = Functions.escaffer6_func(ty, G_nx[i], tO, tM, 0, 0);
        double f = 0.0;
        for (i = 0; i < cf_num; ++i) {
            f += fit[i];
        }
        return f;
    }

    public static final double hf04(double[] x, int nx, double[] Os, double[] Mr, int[] S, int s_flag, int r_flag) {
        int ii;
        int i;
        int cf_num = 4;
        double[] fit = new double[4];
        int[] G = new int[4];
        int[] G_nx = new int[4];
        double[] Gp = new double[]{0.2, 0.2, 0.3, 0.3};
        int tmp = 0;
        for (i = 0; i < cf_num - 1; ++i) {
            G_nx[i] = (int)Math.ceil(Gp[i] * (double)nx);
            tmp += G_nx[i];
        }
        G_nx[cf_num - 1] = nx - tmp;
        G[0] = 0;
        for (i = 1; i < cf_num; ++i) {
            G[i] = G[i - 1] + G_nx[i - 1];
        }
        double[] z = ShiftRotation.sr_func(x, nx, Os, Mr, 1.0, s_flag, r_flag);
        double[] y = new double[nx];
        for (i = 0; i < nx; ++i) {
            y[i] = z[S[i] - 1];
        }
        i = 0;
        double[] ty = new double[G_nx[i]];
        double[] tO = new double[G_nx[i]];
        double[] tM = new double[G_nx[i]];
        for (ii = 0; ii < G_nx[i]; ++ii) {
            ty[ii] = y[ii];
            tO[ii] = Os[ii];
            tM[ii] = Mr[i * nx + ii];
        }
        fit[i] = Functions.hgbat_func(ty, G_nx[i], tO, tM, 0, 0);
        i = 1;
        ty = new double[G_nx[i]];
        tO = new double[G_nx[i]];
        tM = new double[G_nx[i]];
        for (ii = 0; ii < G_nx[i]; ++ii) {
            ty[ii] = y[G_nx[i - 1] + ii];
            tO[ii] = Os[G_nx[i - 1] + ii];
            tM[ii] = Mr[i * nx + ii];
        }
        fit[i] = Functions.discus_func(ty, G_nx[i], tO, tM, 0, 0);
        i = 2;
        ty = new double[G_nx[i]];
        tO = new double[G_nx[i]];
        tM = new double[G_nx[i]];
        for (ii = 0; ii < G_nx[i]; ++ii) {
            ty[ii] = y[G_nx[i - 1] + G_nx[i - 2] + ii];
            tO[ii] = Os[G_nx[i - 1] + G_nx[i - 2] + ii];
            tM[ii] = Mr[i * nx + ii];
        }
        fit[i] = Functions.grie_rosen_func(ty, G_nx[i], tO, tM, 0, 0);
        i = 3;
        ty = new double[G_nx[i]];
        tO = new double[G_nx[i]];
        tM = new double[G_nx[i]];
        for (ii = 0; ii < G_nx[i]; ++ii) {
            ty[ii] = y[G_nx[i - 1] + G_nx[i - 2] + G_nx[i - 3] + ii];
            tO[ii] = Os[G_nx[i - 1] + G_nx[i - 2] + G_nx[i - 3] + ii];
            tM[ii] = Mr[i * nx + ii];
        }
        fit[i] = Functions.rastrigin_func(ty, G_nx[i], tO, tM, 0, 0);
        double f = 0.0;
        for (i = 0; i < cf_num; ++i) {
            f += fit[i];
        }
        return f;
    }

    public static final double hf05(double[] x, int nx, double[] Os, double[] Mr, int[] S, int s_flag, int r_flag) {
        int ii;
        int i;
        int cf_num = 5;
        double[] fit = new double[5];
        int[] G = new int[5];
        int[] G_nx = new int[5];
        double[] Gp = new double[]{0.1, 0.2, 0.2, 0.2, 0.3};
        int tmp = 0;
        for (i = 0; i < cf_num - 1; ++i) {
            G_nx[i] = (int)Math.ceil(Gp[i] * (double)nx);
            tmp += G_nx[i];
        }
        G_nx[cf_num - 1] = nx - tmp;
        G[0] = 0;
        for (i = 1; i < cf_num; ++i) {
            G[i] = G[i - 1] + G_nx[i - 1];
        }
        double[] z = ShiftRotation.sr_func(x, nx, Os, Mr, 1.0, s_flag, r_flag);
        double[] y = new double[nx];
        for (i = 0; i < nx; ++i) {
            y[i] = z[S[i] - 1];
        }
        i = 0;
        double[] ty = new double[G_nx[i]];
        double[] tO = new double[G_nx[i]];
        double[] tM = new double[G_nx[i]];
        for (ii = 0; ii < G_nx[i]; ++ii) {
            ty[ii] = y[ii];
            tO[ii] = Os[ii];
            tM[ii] = Mr[i * nx + ii];
        }
        fit[i] = Functions.escaffer6_func(ty, G_nx[i], tO, tM, 0, 0);
        i = 1;
        ty = new double[G_nx[i]];
        tO = new double[G_nx[i]];
        tM = new double[G_nx[i]];
        for (ii = 0; ii < G_nx[i]; ++ii) {
            ty[ii] = y[G_nx[i - 1] + ii];
            tO[ii] = Os[G_nx[i - 1] + ii];
            tM[ii] = Mr[i * nx + ii];
        }
        fit[i] = Functions.hgbat_func(ty, G_nx[i], tO, tM, 0, 0);
        i = 2;
        ty = new double[G_nx[i]];
        tO = new double[G_nx[i]];
        tM = new double[G_nx[i]];
        for (ii = 0; ii < G_nx[i]; ++ii) {
            ty[ii] = y[G_nx[i - 1] + G_nx[i - 2] + ii];
            tO[ii] = Os[G_nx[i - 1] + G_nx[i - 2] + ii];
            tM[ii] = Mr[i * nx + ii];
        }
        fit[i] = Functions.rosenbrock_func(ty, G_nx[i], tO, tM, 0, 0);
        i = 3;
        ty = new double[G_nx[i]];
        tO = new double[G_nx[i]];
        tM = new double[G_nx[i]];
        for (ii = 0; ii < G_nx[i]; ++ii) {
            ty[ii] = y[G_nx[i - 1] + G_nx[i - 2] + G_nx[i - 3] + ii];
            tO[ii] = Os[G_nx[i - 1] + G_nx[i - 2] + G_nx[i - 3] + ii];
            tM[ii] = Mr[i * nx + ii];
        }
        fit[i] = Functions.schwefel_func(ty, G_nx[i], tO, tM, 0, 0);
        i = 4;
        ty = new double[G_nx[i]];
        tO = new double[G_nx[i]];
        tM = new double[G_nx[i]];
        for (ii = 0; ii < G_nx[i]; ++ii) {
            ty[ii] = y[G_nx[i - 1] + G_nx[i - 2] + G_nx[i - 3] + G_nx[i - 4] + ii];
            tO[ii] = Os[G_nx[i - 1] + G_nx[i - 2] + G_nx[i - 3] + G_nx[i - 4] + ii];
            tM[ii] = Mr[i * nx + ii];
        }
        fit[i] = Functions.ellips_func(ty, G_nx[i], tO, tM, 0, 0);
        double f = 0.0;
        for (i = 0; i < cf_num; ++i) {
            f += fit[i];
        }
        return f;
    }

    public static final double cf01(double[] x, int nx, double[] Os, double[] Mr, int r_flag) {
        int cf_num = 5;
        double[] fit = new double[5];
        double[] delta = new double[]{10.0, 20.0, 30.0, 40.0, 50.0};
        double[] bias = new double[]{0.0, 100.0, 200.0, 300.0, 400.0};
        int i = 0;
        double[] tOs = Arrays.copyOfRange(Os, i * nx, (i + 1) * nx);
        double[] tMr = Arrays.copyOfRange(Mr, i * nx * nx, (i + 1) * nx * nx);
        fit[i] = Functions.rosenbrock_func(x, nx, tOs, tMr, 1, r_flag);
        fit[i] = 10000.0 * fit[i] / 10000.0;
        i = 1;
        tOs = Arrays.copyOfRange(Os, i * nx, (i + 1) * nx);
        tMr = Arrays.copyOfRange(Mr, i * nx * nx, (i + 1) * nx * nx);
        fit[i] = Functions.ellips_func(x, nx, tOs, tMr, 1, r_flag);
        fit[i] = 10000.0 * fit[i] / 1.0E10;
        i = 2;
        tOs = Arrays.copyOfRange(Os, i * nx, (i + 1) * nx);
        tMr = Arrays.copyOfRange(Mr, i * nx * nx, (i + 1) * nx * nx);
        fit[i] = Functions.bent_cigar_func(x, nx, tOs, tMr, 1, r_flag);
        fit[i] = 10000.0 * fit[i] / 1.0E30;
        i = 3;
        tOs = Arrays.copyOfRange(Os, i * nx, (i + 1) * nx);
        tMr = Arrays.copyOfRange(Mr, i * nx * nx, (i + 1) * nx * nx);
        fit[i] = Functions.discus_func(x, nx, tOs, tMr, 1, r_flag);
        fit[i] = 10000.0 * fit[i] / 1.0E10;
        i = 4;
        tOs = Arrays.copyOfRange(Os, i * nx, (i + 1) * nx);
        tMr = Arrays.copyOfRange(Mr, i * nx * nx, (i + 1) * nx * nx);
        fit[i] = Functions.ellips_func(x, nx, tOs, tMr, 1, 0);
        fit[i] = 10000.0 * fit[i] / 1.0E10;
        return Functions.cf_cal(x, nx, Os, delta, bias, fit, cf_num);
    }

    public static final double cf02(double[] x, int nx, double[] Os, double[] Mr, int r_flag) {
        int cf_num = 3;
        double[] fit = new double[3];
        double[] delta = new double[]{20.0, 20.0, 20.0};
        double[] bias = new double[]{0.0, 100.0, 200.0};
        int i = 0;
        double[] tOs = Arrays.copyOfRange(Os, i * nx, (i + 1) * nx);
        double[] tMr = Arrays.copyOfRange(Mr, i * nx * nx, (i + 1) * nx * nx);
        fit[i] = Functions.schwefel_func(x, nx, tOs, tMr, 1, 0);
        i = 1;
        tOs = Arrays.copyOfRange(Os, i * nx, (i + 1) * nx);
        tMr = Arrays.copyOfRange(Mr, i * nx * nx, (i + 1) * nx * nx);
        fit[i] = Functions.rastrigin_func(x, nx, tOs, tMr, 1, r_flag);
        i = 2;
        tOs = Arrays.copyOfRange(Os, i * nx, (i + 1) * nx);
        tMr = Arrays.copyOfRange(Mr, i * nx * nx, (i + 1) * nx * nx);
        fit[i] = Functions.hgbat_func(x, nx, tOs, tMr, 1, r_flag);
        return Functions.cf_cal(x, nx, Os, delta, bias, fit, cf_num);
    }

    public static final double cf03(double[] x, int nx, double[] Os, double[] Mr, int r_flag) {
        int cf_num = 3;
        double[] fit = new double[3];
        double[] delta = new double[]{10.0, 30.0, 50.0};
        double[] bias = new double[]{0.0, 100.0, 200.0};
        int i = 0;
        double[] tOs = Arrays.copyOfRange(Os, i * nx, (i + 1) * nx);
        double[] tMr = Arrays.copyOfRange(Mr, i * nx * nx, (i + 1) * nx * nx);
        fit[i] = Functions.schwefel_func(x, nx, tOs, tMr, 1, r_flag);
        fit[i] = 1000.0 * fit[i] / 4000.0;
        i = 1;
        tOs = Arrays.copyOfRange(Os, i * nx, (i + 1) * nx);
        tMr = Arrays.copyOfRange(Mr, i * nx * nx, (i + 1) * nx * nx);
        fit[i] = Functions.rastrigin_func(x, nx, tOs, tMr, 1, r_flag);
        fit[i] = 1000.0 * fit[i] / 1000.0;
        i = 2;
        tOs = Arrays.copyOfRange(Os, i * nx, (i + 1) * nx);
        tMr = Arrays.copyOfRange(Mr, i * nx * nx, (i + 1) * nx * nx);
        fit[i] = Functions.ellips_func(x, nx, tOs, tMr, 1, r_flag);
        fit[i] = 1000.0 * fit[i] / 1.0E10;
        return Functions.cf_cal(x, nx, Os, delta, bias, fit, cf_num);
    }

    public static final double cf04(double[] x, int nx, double[] Os, double[] Mr, int r_flag) {
        int cf_num = 5;
        double[] fit = new double[5];
        double[] delta = new double[]{10.0, 10.0, 10.0, 10.0, 10.0};
        double[] bias = new double[]{0.0, 100.0, 200.0, 300.0, 400.0};
        int i = 0;
        double[] tOs = Arrays.copyOfRange(Os, i * nx, (i + 1) * nx);
        double[] tMr = Arrays.copyOfRange(Mr, i * nx * nx, (i + 1) * nx * nx);
        fit[i] = Functions.schwefel_func(x, nx, tOs, tMr, 1, r_flag);
        fit[i] = 1000.0 * fit[i] / 4000.0;
        i = 1;
        tOs = Arrays.copyOfRange(Os, i * nx, (i + 1) * nx);
        tMr = Arrays.copyOfRange(Mr, i * nx * nx, (i + 1) * nx * nx);
        fit[i] = Functions.happycat_func(x, nx, tOs, tMr, 1, r_flag);
        fit[i] = 1000.0 * fit[i] / 1000.0;
        i = 2;
        tOs = Arrays.copyOfRange(Os, i * nx, (i + 1) * nx);
        tMr = Arrays.copyOfRange(Mr, i * nx * nx, (i + 1) * nx * nx);
        fit[i] = Functions.ellips_func(x, nx, tOs, tMr, 1, r_flag);
        fit[i] = 1000.0 * fit[i] / 1.0E10;
        i = 3;
        tOs = Arrays.copyOfRange(Os, i * nx, (i + 1) * nx);
        tMr = Arrays.copyOfRange(Mr, i * nx * nx, (i + 1) * nx * nx);
        fit[i] = Functions.weierstrass_func(x, nx, tOs, tMr, 1, r_flag);
        fit[i] = 1000.0 * fit[i] / 400.0;
        i = 4;
        tOs = Arrays.copyOfRange(Os, i * nx, (i + 1) * nx);
        tMr = Arrays.copyOfRange(Mr, i * nx * nx, (i + 1) * nx * nx);
        fit[i] = Functions.griewank_func(x, nx, tOs, tMr, 1, r_flag);
        fit[i] = 1000.0 * fit[i] / 100.0;
        return Functions.cf_cal(x, nx, Os, delta, bias, fit, cf_num);
    }

    public static final double cf05(double[] x, int nx, double[] Os, double[] Mr, int r_flag) {
        int cf_num = 5;
        double[] fit = new double[5];
        double[] delta = new double[]{10.0, 10.0, 10.0, 20.0, 20.0};
        double[] bias = new double[]{0.0, 100.0, 200.0, 300.0, 400.0};
        int i = 0;
        double[] tOs = Arrays.copyOfRange(Os, i * nx, (i + 1) * nx);
        double[] tMr = Arrays.copyOfRange(Mr, i * nx * nx, (i + 1) * nx * nx);
        fit[i] = Functions.hgbat_func(x, nx, tOs, tMr, 1, r_flag);
        fit[i] = 10000.0 * fit[i] / 1000.0;
        i = 1;
        tOs = Arrays.copyOfRange(Os, i * nx, (i + 1) * nx);
        tMr = Arrays.copyOfRange(Mr, i * nx * nx, (i + 1) * nx * nx);
        fit[i] = Functions.rastrigin_func(x, nx, tOs, tMr, 1, r_flag);
        fit[i] = 10000.0 * fit[i] / 1000.0;
        i = 2;
        tOs = Arrays.copyOfRange(Os, i * nx, (i + 1) * nx);
        tMr = Arrays.copyOfRange(Mr, i * nx * nx, (i + 1) * nx * nx);
        fit[i] = Functions.schwefel_func(x, nx, tOs, tMr, 1, r_flag);
        fit[i] = 10000.0 * fit[i] / 4000.0;
        i = 3;
        tOs = Arrays.copyOfRange(Os, i * nx, (i + 1) * nx);
        tMr = Arrays.copyOfRange(Mr, i * nx * nx, (i + 1) * nx * nx);
        fit[i] = Functions.weierstrass_func(x, nx, tOs, tMr, 1, r_flag);
        fit[i] = 10000.0 * fit[i] / 400.0;
        i = 4;
        tOs = Arrays.copyOfRange(Os, i * nx, (i + 1) * nx);
        tMr = Arrays.copyOfRange(Mr, i * nx * nx, (i + 1) * nx * nx);
        fit[i] = Functions.ellips_func(x, nx, tOs, tMr, 1, r_flag);
        fit[i] = 10000.0 * fit[i] / 1.0E10;
        return Functions.cf_cal(x, nx, Os, delta, bias, fit, cf_num);
    }

    public static final double cf06(double[] x, int nx, double[] Os, double[] Mr, int r_flag) {
        int cf_num = 5;
        double[] fit = new double[5];
        double[] delta = new double[]{10.0, 20.0, 30.0, 40.0, 50.0};
        double[] bias = new double[]{0.0, 100.0, 200.0, 300.0, 400.0};
        int i = 0;
        double[] tOs = Arrays.copyOfRange(Os, i * nx, (i + 1) * nx);
        double[] tMr = Arrays.copyOfRange(Mr, i * nx * nx, (i + 1) * nx * nx);
        fit[i] = Functions.grie_rosen_func(x, nx, tOs, tMr, 1, r_flag);
        fit[i] = 10000.0 * fit[i] / 4000.0;
        i = 1;
        tOs = Arrays.copyOfRange(Os, i * nx, (i + 1) * nx);
        tMr = Arrays.copyOfRange(Mr, i * nx * nx, (i + 1) * nx * nx);
        fit[i] = Functions.happycat_func(x, nx, tOs, tMr, 1, r_flag);
        fit[i] = 10000.0 * fit[i] / 1000.0;
        i = 2;
        tOs = Arrays.copyOfRange(Os, i * nx, (i + 1) * nx);
        tMr = Arrays.copyOfRange(Mr, i * nx * nx, (i + 1) * nx * nx);
        fit[i] = Functions.schwefel_func(x, nx, tOs, tMr, 1, r_flag);
        fit[i] = 10000.0 * fit[i] / 4000.0;
        i = 3;
        tOs = Arrays.copyOfRange(Os, i * nx, (i + 1) * nx);
        tMr = Arrays.copyOfRange(Mr, i * nx * nx, (i + 1) * nx * nx);
        fit[i] = Functions.escaffer6_func(x, nx, tOs, tMr, 1, r_flag);
        fit[i] = 10000.0 * fit[i] / 2.0E7;
        i = 4;
        tOs = Arrays.copyOfRange(Os, i * nx, (i + 1) * nx);
        tMr = Arrays.copyOfRange(Mr, i * nx * nx, (i + 1) * nx * nx);
        fit[i] = Functions.ellips_func(x, nx, tOs, tMr, 1, r_flag);
        fit[i] = 10000.0 * fit[i] / 1.0E10;
        return Functions.cf_cal(x, nx, Os, delta, bias, fit, cf_num);
    }

    public static final double cf07(double[] x, int nx, double[] Os, double[] Mr, int[] SS, int r_flag) {
        int cf_num = 3;
        double[] fit = new double[3];
        double[] delta = new double[]{10.0, 30.0, 50.0};
        double[] bias = new double[]{0.0, 100.0, 200.0};
        int i = 0;
        double[] tOs = Arrays.copyOfRange(Os, i * nx, (i + 1) * nx);
        double[] tMr = Arrays.copyOfRange(Mr, i * nx * nx, (i + 1) * nx * nx);
        int[] tSS = Arrays.copyOfRange(SS, i * nx, (i + 1) * nx);
        fit[i] = Functions.hf01(x, nx, tOs, tMr, tSS, 1, r_flag);
        i = 1;
        tOs = Arrays.copyOfRange(Os, i * nx, (i + 1) * nx);
        tMr = Arrays.copyOfRange(Mr, i * nx * nx, (i + 1) * nx * nx);
        tSS = Arrays.copyOfRange(SS, i * nx, (i + 1) * nx);
        fit[i] = Functions.hf02(x, nx, tOs, tMr, tSS, 1, r_flag);
        i = 2;
        tOs = Arrays.copyOfRange(Os, i * nx, (i + 1) * nx);
        tMr = Arrays.copyOfRange(Mr, i * nx * nx, (i + 1) * nx * nx);
        tSS = Arrays.copyOfRange(SS, i * nx, (i + 1) * nx);
        fit[i] = Functions.hf03(x, nx, tOs, tMr, tSS, 1, r_flag);
        return Functions.cf_cal(x, nx, Os, delta, bias, fit, cf_num);
    }

    public static final double cf08(double[] x, int nx, double[] Os, double[] Mr, int[] SS, int r_flag) {
        int cf_num = 3;
        double[] fit = new double[3];
        double[] delta = new double[]{10.0, 30.0, 50.0};
        double[] bias = new double[]{0.0, 100.0, 200.0};
        int i = 0;
        double[] tOs = Arrays.copyOfRange(Os, i * nx, (i + 1) * nx);
        double[] tMr = Arrays.copyOfRange(Mr, i * nx * nx, (i + 1) * nx * nx);
        int[] tSS = Arrays.copyOfRange(SS, i * nx, (i + 1) * nx);
        fit[i] = Functions.hf04(x, nx, tOs, tMr, tSS, 1, r_flag);
        i = 1;
        tOs = Arrays.copyOfRange(Os, i * nx, (i + 1) * nx);
        tMr = Arrays.copyOfRange(Mr, i * nx * nx, (i + 1) * nx * nx);
        tSS = Arrays.copyOfRange(SS, i * nx, (i + 1) * nx);
        fit[i] = Functions.hf05(x, nx, tOs, tMr, tSS, 1, r_flag);
        i = 2;
        tOs = Arrays.copyOfRange(Os, i * nx, (i + 1) * nx);
        tMr = Arrays.copyOfRange(Mr, i * nx * nx, (i + 1) * nx * nx);
        tSS = Arrays.copyOfRange(SS, i * nx, (i + 1) * nx);
        fit[i] = Functions.hf06(x, nx, tOs, tMr, tSS, 1, r_flag);
        return Functions.cf_cal(x, nx, Os, delta, bias, fit, cf_num);
    }

    public static final double hf06(double[] x, int nx, double[] Os, double[] Mr, int[] S, int s_flag, int r_flag) {
        int ii;
        int i;
        int cf_num = 5;
        double[] fit = new double[5];
        int[] G = new int[5];
        int[] G_nx = new int[5];
        double[] Gp = new double[]{0.1, 0.2, 0.2, 0.2, 0.3};
        int tmp = 0;
        for (i = 0; i < cf_num - 1; ++i) {
            G_nx[i] = (int)Math.ceil(Gp[i] * (double)nx);
            tmp += G_nx[i];
        }
        G_nx[cf_num - 1] = nx - tmp;
        G[0] = 0;
        for (i = 1; i < cf_num; ++i) {
            G[i] = G[i - 1] + G_nx[i - 1];
        }
        double[] z = ShiftRotation.sr_func(x, nx, Os, Mr, 1.0, s_flag, r_flag);
        double[] y = new double[nx];
        for (i = 0; i < nx; ++i) {
            y[i] = z[S[i] - 1];
        }
        i = 0;
        double[] ty = new double[G_nx[i]];
        double[] tO = new double[G_nx[i]];
        double[] tM = new double[G_nx[i]];
        for (ii = 0; ii < G_nx[i]; ++ii) {
            ty[ii] = y[ii];
            tO[ii] = Os[ii];
            tM[ii] = Mr[i * nx + ii];
        }
        fit[i] = Functions.katsuura_func(ty, G_nx[i], tO, tM, 0, 0);
        i = 1;
        ty = new double[G_nx[i]];
        tO = new double[G_nx[i]];
        tM = new double[G_nx[i]];
        for (ii = 0; ii < G_nx[i]; ++ii) {
            ty[ii] = y[G_nx[i - 1] + ii];
            tO[ii] = Os[G_nx[i - 1] + ii];
            tM[ii] = Mr[i * nx + ii];
        }
        fit[i] = Functions.happycat_func(ty, G_nx[i], tO, tM, 0, 0);
        i = 2;
        ty = new double[G_nx[i]];
        tO = new double[G_nx[i]];
        tM = new double[G_nx[i]];
        for (ii = 0; ii < G_nx[i]; ++ii) {
            ty[ii] = y[G_nx[i - 1] + G_nx[i - 2] + ii];
            tO[ii] = Os[G_nx[i - 1] + G_nx[i - 2] + ii];
            tM[ii] = Mr[i * nx + ii];
        }
        fit[i] = Functions.grie_rosen_func(ty, G_nx[i], tO, tM, 0, 0);
        i = 3;
        ty = new double[G_nx[i]];
        tO = new double[G_nx[i]];
        tM = new double[G_nx[i]];
        for (ii = 0; ii < G_nx[i]; ++ii) {
            ty[ii] = y[G_nx[i - 1] + G_nx[i - 2] + G_nx[i - 3] + ii];
            tO[ii] = Os[G_nx[i - 1] + G_nx[i - 2] + G_nx[i - 3] + ii];
            tM[ii] = Mr[i * nx + ii];
        }
        fit[i] = Functions.schwefel_func(ty, G_nx[i], tO, tM, 0, 0);
        i = 4;
        ty = new double[G_nx[i]];
        tO = new double[G_nx[i]];
        tM = new double[G_nx[i]];
        for (ii = 0; ii < G_nx[i]; ++ii) {
            ty[ii] = y[G_nx[i - 1] + G_nx[i - 2] + G_nx[i - 3] + G_nx[i - 4] + ii];
            tO[ii] = Os[G_nx[i - 1] + G_nx[i - 2] + G_nx[i - 3] + G_nx[i - 4] + ii];
            tM[ii] = Mr[i * nx + ii];
        }
        fit[i] = Functions.ackley_func(ty, G_nx[i], tO, tM, 0, 0);
        double f = 0.0;
        for (i = 0; i < cf_num; ++i) {
            f += fit[i];
        }
        return f;
    }

    public static final double[] oszfunc(double[] x, int nx) {
        double[] xosz = new double[nx];
        double xx = 0.0;
        for (int i = 0; i < nx; ++i) {
            if (i == 0 || i == nx - 1) {
                double c2;
                double c1;
                if (x[i] != 0.0) {
                    xx = Math.log(Math.abs(x[i]));
                }
                if (x[i] > 0.0) {
                    c1 = 10.0;
                    c2 = 7.9;
                } else {
                    c1 = 5.5;
                    c2 = 3.1;
                }
                int sx = x[i] > 0.0 ? 1 : (x[i] == 0.0 ? 0 : -1);
                xosz[i] = (double)sx * Math.exp(xx + 0.049 * (Math.sin(c1 * xx) + Math.sin(c2 * xx)));
                continue;
            }
            xosz[i] = x[i];
        }
        return xosz;
    }

    public static final double cf_cal(double[] x, int nx, double[] Os, double[] delta, double[] bias, double[] fit, int cf_num) {
        int i;
        double w_max = 0.0;
        double w_sum = 0.0;
        double[] w = new double[cf_num];
        for (i = 0; i < cf_num; ++i) {
            int n = i;
            fit[n] = fit[n] + bias[i];
            w[i] = 0.0;
            for (int j = 0; j < nx; ++j) {
                int n2 = i;
                w[n2] = w[n2] + Math.pow(x[j] - Os[i * nx + j], 2.0);
            }
            w[i] = w[i] != 0.0 ? Math.pow(1.0 / w[i], 0.5) * Math.exp(-w[i] / 2.0 / (double)nx / Math.pow(delta[i], 2.0)) : 1.0E99;
            if (!(w[i] > w_max)) continue;
            w_max = w[i];
        }
        for (i = 0; i < cf_num; ++i) {
            w_sum += w[i];
        }
        if (w_max == 0.0) {
            for (i = 0; i < cf_num; ++i) {
                w[i] = 1.0;
            }
            w_sum = cf_num;
        }
        double f = 0.0;
        for (i = 0; i < cf_num; ++i) {
            f += w[i] / w_sum * fit[i];
        }
        return f;
    }
}

