/*
 * Decompiled with CFR 0.152.
 */
package cec2015;

import cec2015.math.Functions;
import cec2015.profiler.FEvCount;
import cec2015.profiler.ResultRecorder;
import input_data.DataReader;
import java.util.ArrayList;
import java.util.Arrays;

public class CEC15Problems {
    private final ArrayList<FEvCount> funcEvalCounters = new ArrayList();
    private final ArrayList<Integer> runs = new ArrayList();
    private final ResultRecorder rr;
    private double[] OShift;
    private double[] M;
    private double[] y;
    private double[] z;
    private double[] x_bound;
    private int ini_flag;
    private int n_flag;
    private int func_flag;
    private int[] SS;
    private int currentRun;

    public CEC15Problems() {
        this(1, null);
    }

    public CEC15Problems(String resultFilePrefix) {
        this(1, new ResultRecorder(resultFilePrefix));
    }

    private CEC15Problems(int run, ResultRecorder r) {
        this.rr = r;
        this.currentRun = run;
        this.runs.add(run);
        float[] rp = new float[]{0.01f, 0.02f, 0.03f, 0.04f, 0.05f, 0.06f, 0.07f, 0.08f, 0.09f, 0.1f, 0.2f, 0.3f, 0.4f, 0.5f, 0.6f, 0.7f, 0.8f, 0.9f, 1.0f};
        for (int dim = 10; dim <= 30; dim += 20) {
            int[] rp10_30 = new int[rp.length];
            for (int i = 0; i < rp.length; ++i) {
                rp10_30[i] = Math.round((float)(50 * dim) * rp[i]);
            }
            this.addRecordRule(dim, rp10_30);
        }
    }

    public double[] getCurrentBestX(int func_num, int n, int run) {
        if (this.rr != null) {
            return this.getFuncEvalCounter(run).getCurrentBestX(func_num, n);
        }
        return null;
    }

    public int getEvalCount(int func_num, int n, int run) {
        if (this.rr != null) {
            return this.getFuncEvalCounter(run).getCount(func_num, n);
        }
        return 0;
    }

    public double getCurrentBest(int func_num, int n, int run) {
        if (this.rr != null) {
            return this.getFuncEvalCounter(run).getCurrentBest(func_num, n);
        }
        return Double.NaN;
    }

    public double[] getCurrentBestX(int func_num, int n) {
        return this.getCurrentBestX(func_num, n, this.getNumberOfRun());
    }

    public int getEvalCount(int func_num, int n) {
        return this.getEvalCount(func_num, n, this.getNumberOfRun());
    }

    public double getCurrentBest(int func_num, int n) {
        return this.getCurrentBest(func_num, n, this.getNumberOfRun());
    }

    private void addRecordRule(int dim, int[] recordPoints) {
        if (this.rr != null) {
            this.rr.addRecordRule(dim, recordPoints);
        }
    }

    public void setNumberOfRun(int run) {
        if (this.runs.contains(run)) {
            this.currentRun = run;
        } else {
            this.runs.add(run);
            this.currentRun = run;
        }
    }

    public int getNumberOfRun() {
        return this.currentRun;
    }

    public int[] getRuns() {
        int[] ret = new int[this.runs.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.runs.get(i);
        }
        Arrays.sort(ret);
        return ret;
    }

    public void writeResultToFiles() {
        if (this.rr != null) {
            this.rr.flush();
        }
    }

    public double[] eval(double[] x, int nx, int mx, int func_num) {
        int i;
        if (func_num < 1 || func_num > 15) {
            return null;
        }
        int cf_num = 10;
        if (this.ini_flag == 1 && (this.n_flag != nx || this.func_flag != func_num)) {
            this.ini_flag = 0;
        }
        if (this.ini_flag == 0) {
            this.y = new double[nx];
            this.z = new double[nx];
            this.x_bound = new double[nx];
            for (i = 0; i < nx; ++i) {
                this.x_bound[i] = 100.0;
            }
            if (nx != 10 && nx != 30) {
                System.out.println("\nError: Expensive Test functions are only defined for D=10, 30.");
                return null;
            }
            this.M = DataReader.readRotation(func_num, nx, cf_num);
            this.OShift = DataReader.readShiftData(func_num, nx, cf_num);
            this.SS = DataReader.readShuffleData(func_num, nx);
            this.n_flag = nx;
            this.func_flag = func_num;
            this.ini_flag = 1;
        }
        double[] f = new double[mx];
        Arrays.fill(f, (double)func_num * 100.0);
        block18: for (i = 0; i < mx; ++i) {
            double[] t = Arrays.copyOfRange(x, i * nx, (i + 1) * nx);
            switch (func_num) {
                case 1: {
                    int n = i;
                    f[n] = f[n] + Functions.bent_cigar_func(t, nx, this.OShift, this.M, 1, 1);
                    continue block18;
                }
                case 2: {
                    int n = i;
                    f[n] = f[n] + Functions.discus_func(t, nx, this.OShift, this.M, 1, 1);
                    continue block18;
                }
                case 3: {
                    int n = i;
                    f[n] = f[n] + Functions.weierstrass_func(t, nx, this.OShift, this.M, 1, 1);
                    continue block18;
                }
                case 4: {
                    int n = i;
                    f[n] = f[n] + Functions.schwefel_func(t, nx, this.OShift, this.M, 1, 0);
                    continue block18;
                }
                case 5: {
                    int n = i;
                    f[n] = f[n] + Functions.katsuura_func(t, nx, this.OShift, this.M, 1, 1);
                    continue block18;
                }
                case 6: {
                    int n = i;
                    f[n] = f[n] + Functions.happycat_func(t, nx, this.OShift, this.M, 1, 1);
                    continue block18;
                }
                case 7: {
                    int n = i;
                    f[n] = f[n] + Functions.hgbat_func(t, nx, this.OShift, this.M, 1, 1);
                    continue block18;
                }
                case 8: {
                    int n = i;
                    f[n] = f[n] + Functions.grie_rosen_func(t, nx, this.OShift, this.M, 1, 1);
                    continue block18;
                }
                case 9: {
                    int n = i;
                    f[n] = f[n] + Functions.escaffer6_func(t, nx, this.OShift, this.M, 1, 1);
                    continue block18;
                }
                case 10: {
                    int n = i;
                    f[n] = f[n] + Functions.hf01(t, nx, this.OShift, this.M, this.SS, 1, 1);
                    continue block18;
                }
                case 11: {
                    int n = i;
                    f[n] = f[n] + Functions.hf03(t, nx, this.OShift, this.M, this.SS, 1, 1);
                    continue block18;
                }
                case 12: {
                    int n = i;
                    f[n] = f[n] + Functions.hf06(t, nx, this.OShift, this.M, this.SS, 1, 1);
                    continue block18;
                }
                case 13: {
                    int n = i;
                    f[n] = f[n] + Functions.cf01(t, nx, this.OShift, this.M, 1);
                    continue block18;
                }
                case 14: {
                    int n = i;
                    f[n] = f[n] + Functions.cf03(t, nx, this.OShift, this.M, 1);
                    continue block18;
                }
                case 15: {
                    int n = i;
                    f[n] = f[n] + Functions.cf05(t, nx, this.OShift, this.M, 1);
                    continue block18;
                }
            }
        }
        if (this.getFuncEvalCounter(this.getNumberOfRun()) != null) {
            this.getFuncEvalCounter(this.getNumberOfRun()).eval(func_num, nx, x, f);
        }
        return f;
    }

    private void makeStatistics() {
    }

    private FEvCount getFuncEvalCounter(int run) {
        if (this.rr == null) {
            return null;
        }
        for (FEvCount counter : this.funcEvalCounters) {
            if (counter.getCurrentRun() != run) continue;
            return counter;
        }
        FEvCount fc = new FEvCount(30, 100, run, this.rr);
        this.funcEvalCounters.add(fc);
        return fc;
    }
}

